<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Admin Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

  
</head>
<body>
<?php
    require "Sidebar.php" ;

    ?>
  

  <div class="main">
    <div class="header">
      <h1>Dashboard Overview</h1>
      <p>Selamat datang di admin dashboard</p>
    </div>

    <div class="stats">
      <div class="card">
        <div class="card-title">Total Pesanan</div>
        <div class="card-value" id="totalOrders">0</div>
      </div>

      <div class="card">
        <div class="card-title">Pesanan Pending</div>
        <div class="card-value" id="pendingOrders">0</div>
      </div>

      <div class="card">
        <div class="card-title">Pesanan Selesai</div>
        <div class="card-value" id="completedOrders">0</div>
      </div>

      <div class="card">
        <div class="card-title">Total Pendapatan</div>
        <div class="card-value" id="totalRevenue">Rp 0</div>
      </div>
    </div>

    <div class="orders">
      <h3>Pesanan Terbaru</h3>
      <div id="recentOrders"></div>
    </div>

    <div class="actions">
      <button class="action-btn blue">📷 Scan Barcode</button>
      <button class="action-btn green">📦 Kelola Pesanan</button>
      <button class="action-btn purple">📄 Laporan</button>
    </div>
  </div>

  <script>
    const orders = [
      {
        id: 1,
        orderNumber: "ORD-001",
        items: ["Produk A", "Produk B"],
        total: 150000,
        status: "pending",
        timestamp: Date.now()
      },
      {
        id: 2,
        orderNumber: "ORD-002",
        items: ["Produk C"],
        total: 300000,
        status: "completed",
        timestamp: Date.now()
      }
    ];

    function formatRupiah(value) {
      return "Rp " + value.toLocaleString("id-ID");
    }

    function renderDashboard() {
      const pending = orders.filter(o => o.status === "pending").length;
      const completed = orders.filter(o => o.status === "completed").length;
      const revenue = orders
        .filter(o => o.status === "completed")
        .reduce((sum, o) => sum + o.total, 0);

      document.getElementById("totalOrders").innerText = orders.length;
      document.getElementById("pendingOrders").innerText = pending;
      document.getElementById("completedOrders").innerText = completed;
      document.getElementById("totalRevenue").innerText = formatRupiah(revenue);

      const container = document.getElementById("recentOrders");
      container.innerHTML = "";

      orders.slice(0, 5).forEach(order => {
        container.innerHTML += `
          <div class="order-item">
            <div>
              <strong>${order.orderNumber}</strong><br/>
              <small>${order.items.join(", ")}</small>
            </div>
            <div>
              ${formatRupiah(order.total)}<br/>
              <span class="badge ${order.status}">
                ${order.status === "pending" ? "Pending" : "Selesai"}
              </span>
            </div>
          </div>
        `;
      });
    }

    function logout() {
      location.reload();
    }

    renderDashboard();
  </script>

</body>
</html>