  <?php
    require "Sidebar.php" ;

    ?>
<div class="main">
      <h2>Laporan Transaksi</h2>
  <p class="filters">Generate dan cetak laporan transaksi</p>

<div class="container">

  <div class="card">
    <h2>Tambah Produk Baru</h2>

    <form id="productForm" enctype="multipart/form-data" class="form-grid">

      <input name="product_name" placeholder="Nama Produk">

      <input type="number" name="price" placeholder="Harga">

      <select name="category_id">
        <option value="1">Makanan</option>
        <option value="2">Minuman</option>
        <option value="3">Snack</option>
      </select>

      <input name="product_type" placeholder="Jenis Produk">

      <input type="number" name="stock" placeholder="Stok">

      <select name="status">
        <option value="ready">Ready</option>
        <option value="habis">Habis</option>
      </select>

      <textarea name="description" placeholder="Keterangan Produk" class="full"></textarea>

      <input type="file" name="image" class="full">

      <button type="submit" class="full">Simpan Produk</button>

    </form>
  </div>
  
<div class="filter-bar">

  <div class="search-box">
    <span class="icon">🔍</span>
    <input type="text" id="searchInput" placeholder="Cari produk...">
  </div>

  <select id="categoryFilter">
    <option value="">Semua Kategori</option>
    <option value="Makanan">Makanan</option>
    <option value="Minuman">Minuman</option>
    <option value="Snack">Snack</option>
  </select>

  <select id="statusFilter">
    <option value="">Semua Status</option>
    <option value="ready">Ready</option>
    <option value="habis">Habis</option>
  </select>

</div>

  <div class="card">
    <h2>Daftar Produk</h2>

    <table id="productTable">
      <thead>
        <tr>
          <th>Gambar</th>
          <th>Nama</th>
          <th>Kategori</th>
          <th>Harga</th>
          <th>Stok</th>
          <th>Aksi</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>

</div>

</div>
<style>

    body {
    font-family: Arial, sans-serif;
    background: #f5f7fb;
    margin: 0;
    padding: 40px;
}

.container {
    max-width: 1100px;
    margin: auto;
}

.card {
    background: white;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.06);
    margin-bottom: 30px;
}

h2 {
    margin-top: 0;
}

.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
}

.full {
    grid-column: span 2;
}

input, select, textarea {
    width: 100%;
    padding: 10px;
    border-radius: 8px;
    border: 1px solid #ddd;
    font-size: 14px;
}

textarea {
    resize: none;
    height: 90px;
}

button {
    background: #2563eb;
    color: white;
    border: none;
    padding: 10px 18px;
    border-radius: 8px;
    cursor: pointer;
}

button:hover {
    background: #1d4ed8;
}

table {
    width: 100%;
    border-collapse: collapse;
}

th {
    text-align: left;
    background: #f9fafb;
}

th, td {
    padding: 12px;
    border-bottom: 1px solid #eee;
}

img.thumb {
    width: 55px;
    height: 55px;
    object-fit: cover;
    border-radius: 8px;
}

    .filter-bar {
    display: flex;
    gap: 15px;
    margin-bottom: 20px;
}

.search-box {
    flex: 1;
    display: flex;
    align-items: center;
    background: #f9fafb;
    border: 1px solid #eee;
    border-radius: 10px;
    padding: 0 10px;
}

.search-box input {
    border: none;
    background: transparent;
    padding: 10px;
    outline: none;
    flex: 1;
}

.search-box .icon {
    opacity: 0.5;
}

.filter-bar select {
    padding: 10px;
    border-radius: 10px;
    border: 1px solid #eee;
    background: white;
    min-width: 160px;
}

</style>

<script>
let allProducts = [];

function loadProducts() {
  fetch("../backend/get_products.php")
    .then(res => res.text()) // ambil raw dulu
    .then(text => {
      console.log("RAW RESPONSE:", text);

      try {
        const data = JSON.parse(text);
        allProducts = data;
        renderProducts();
      } catch (e) {
        alert("Response bukan JSON valid");
        console.error(e);
      }
    })
    .catch(err => {
      alert("Gagal konek ke backend");
      console.error(err);
    });
}


function renderProducts() {
  const search = document.getElementById("searchInput").value.toLowerCase();
  const category = document.getElementById("categoryFilter").value;
  const status = document.getElementById("statusFilter").value;

  const tbody = document.querySelector("#productTable tbody");
  tbody.innerHTML = "";

  allProducts
  .filter(p => {
  const name = (p.product_name || "").toLowerCase();

  const matchSearch = name.includes(search);
  const matchCategory = !category || p.category_name === category;
  const matchStatus = !status || p.status === status;

  return matchSearch && matchCategory && matchStatus;
})

    .forEach(p => {
      tbody.innerHTML += `
        <tr>
         <td>
  <img class="thumb" src="/projectTA/uploads/${p.image || ''}">
</td>

          <td>${p.product_name}</td>
          <td>${p.category_name || '-'}</td>
          <td>Rp ${Number(p.price).toLocaleString('id-ID')}</td>
          <td>${p.stock}</td>
          <td>
            <button onclick="deleteProduct(${p.product_id})">Hapus</button>
          </td>
        </tr>
      `;
    });
}

function deleteProduct(id) {
  if (!confirm("Hapus produk?")) return;

  const fd = new FormData();
  fd.append("id", id);

  fetch("../backend/delete_product.php", {
    method: "POST",
    body: fd
  }).then(() => loadProducts());
}

document.getElementById("productForm").onsubmit = function(e) {
  e.preventDefault();

  const fd = new FormData(this);

  fetch("../backend/save_product.php", {
    method: "POST",
    body: fd   // ✅ BENAR
  })
  .then(res => res.text())
  .then(result => {
    console.log("SERVER RESPONSE:", result);

    if (result.includes("SUCCESS")) {
      alert("Produk berhasil disimpan");
      this.reset();
      loadProducts();
    } else {
      alert(result);
    }
  })
  .catch(err => {
    console.error("FETCH ERROR:", err);
    alert("Terjadi error koneksi ke server");
  });
};


document.getElementById("searchInput").oninput = renderProducts;
document.getElementById("categoryFilter").onchange = renderProducts;
document.getElementById("statusFilter").onchange = renderProducts;

loadProducts();
</script>
