<!DOCTYPE html>
<html lang="id">
<head>

  <meta charset="UTF-8">
  <title>Kelola Pesanan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f3f4f6;
    }

  

    .menu button {
      width: 100%;
      padding: 10px;
      margin-bottom: 8px;
      border: none;
      background: #f3f4f6;
      border-radius: 6px;
      cursor: pointer;
      text-align: left;
    }

 

  

 

    .card {
      background: white;
      border-radius: 10px;
      padding: 16px;
      margin-bottom: 16px;
      border: 1px solid #e5e7eb;
    }

    input, select {
      padding: 8px;
      border-radius: 6px;
      border: 1px solid #d1d5db;
      width: 100%;
      box-sizing: border-box;
    }

    .row {
      display: flex;
      gap: 10px;
    }

    .tabs button {
      padding: 8px 12px;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      background: #e5e7eb;
    }

    .tabs button.active {
      background: #2563eb;
      color: white;
    }

    .order {
      background: white;
      border-radius: 10px;
      border: 1px solid #e5e7eb;
      padding: 16px;
    }

    .badge {
      padding: 4px 8px;
      border-radius: 20px;
      font-size: 12px;
    }

    .pending { background: #fef9c3; color: #92400e; }
    .completed { background: #dcfce7; color: #166534; }

    .btn {
      padding: 8px 12px;
      border: none;
      border-radius: 6px;
      cursor: pointer;
    }

    .btn-primary { background: #2563eb; color: white; }
    .btn-success { background: #16a34a; color: white; }

    .grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
      gap: 16px;
    }

    .modal {
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,0.4);
      display: none;
      align-items: center;
      justify-content: center;
    }

    .modal-box {
      background: white;
      padding: 20px;
      border-radius: 10px;
      width: 320px;
    }
  </style>
</head>

<body>

  <?php
    require "Sidebar.php" ;

    ?>

<div class="main">

  <h1>Kelola Pesanan</h1>

  <div class="card">
    <div class="row">
      <input type="text" id="search" placeholder="Cari pesanan / item...">
      <button class="btn" onclick="toggleFilters()">Filter</button>
    </div>

    <div id="filters" style="display:none; margin-top:10px;">
      <div class="row">
        <select id="dateFilter">
          <option value="all">Semua Waktu</option>
          <option value="today">Hari Ini</option>
        </select>
        <input type="number" id="minAmount" placeholder="Min Harga">
        <input type="number" id="maxAmount" placeholder="Max Harga">
      </div>
    </div>
  </div>

  <div class="card tabs">
    <button onclick="setStatusFilter('all')" id="tab-all">Semua</button>
    <button onclick="setStatusFilter('pending')" id="tab-pending">Pending</button>
    <button onclick="setStatusFilter('completed')" id="tab-completed">Selesai</button>
  </div>

  <div class="grid" id="ordersContainer"></div>

</div>

<div class="modal" id="modal">
  <div class="modal-box">
    <h3>Konfirmasi</h3>
    <p id="modalText"></p>
    <div class="row">
      <button class="btn" onclick="closeModal()">Batal</button>
      <button class="btn btn-success" onclick="confirmComplete()">Ya</button>
    </div>
  </div>
</div>

<script>
  let orders = [
    {
      id: "1",
      orderNumber: "ORD-1001",
      items: ["Nasi Goreng", "Es Teh"],
      total: 25000,
      status: "pending",
      timestamp: Date.now()
    },
    {
      id: "2",
      orderNumber: "ORD-1002",
      items: ["Mie Ayam"],
      total: 15000,
      status: "completed",
      timestamp: Date.now()
    }
  ];

  let statusFilter = "all";
  let selectedOrderId = null;

  function toggleFilters() {
    const f = document.getElementById("filters");
    f.style.display = f.style.display === "none" ? "block" : "none";
  }

  function setStatusFilter(filter) {
    statusFilter = filter;
    renderOrders();
  }

  function renderOrders() {
    const container = document.getElementById("ordersContainer");
    const search = document.getElementById("search").value.toLowerCase();

    container.innerHTML = "";

    const filtered = orders.filter(o => {
      if (statusFilter !== "all" && o.status !== statusFilter) return false;

      if (search) {
        if (!o.orderNumber.toLowerCase().includes(search) &&
            !o.items.some(i => i.toLowerCase().includes(search))) return false;
      }

      return true;
    });

    filtered.forEach(order => {
      const div = document.createElement("div");
      div.className = "order";

      div.innerHTML = `
        <strong>${order.orderNumber}</strong><br>
        <small>${new Date(order.timestamp).toLocaleString('id-ID')}</small>
        <ul>${order.items.map(i => `<li>${i}</li>`).join("")}</ul>
        <strong>Rp ${order.total.toLocaleString('id-ID')}</strong><br><br>
        ${
          order.status === "pending"
          ? `<button class="btn btn-primary" onclick="openModal('${order.id}', '${order.orderNumber}')">Selesaikan</button>`
          : `<span class="badge completed">Selesai</span>`
        }
      `;

      container.appendChild(div);
    });
  }

  function openModal(id, number) {
    selectedOrderId = id;
    document.getElementById("modalText").innerText =
      `Tandai pesanan ${number} sebagai selesai?`;
    document.getElementById("modal").style.display = "flex";
  }

  function closeModal() {
    document.getElementById("modal").style.display = "none";
  }

  function confirmComplete() {
    orders = orders.map(o =>
      o.id === selectedOrderId ? { ...o, status: "completed" } : o
    );
    closeModal();
    renderOrders();
  }

  renderOrders();
</script>

</body>
</html>