<!DOCTYPE html>
<html lang="id">
<head>
    
  <meta charset="UTF-8" />
  <title>Scan Barcode</title>
  <style>
    * { box-sizing: border-box; font-family: Arial, sans-serif; }
    body { margin: 0; background: #f5f6f8; color: #1f2933; }



    .nav {
      padding: 10px;
      flex: 1;
    }

    .nav button {
      width: 100%;
      padding: 12px;
      border: none;
      background: none;
      text-align: left;
      border-radius: 8px;
      cursor: pointer;
    }

    .nav button:hover { background: #f3f4f6; }
    .nav .active { background: #e0edff; color: #2563eb; }

    .logout {
      padding: 10px;
      border-top: 1px solid #e5e7eb;
    }

    .logout button {
      width: 100%;
      padding: 12px;
      border: none;
      background: none;
      color: #dc2626;
      border-radius: 8px;
      cursor: pointer;
    }

    .logout button:hover { background: #fee2e2; }

    /* Main */
    .main {
      margin-left: 260px;
      padding: 30px;
    }

    .card {
      background: white;
      border: 1px solid #e5e7eb;
      border-radius: 14px;
      padding: 20px;
      margin-bottom: 20px;
    }

    .toggle {
      display: flex;
      gap: 10px;
      margin-bottom: 20px;
    }

    .toggle button {
      flex: 1;
      padding: 12px;
      border-radius: 10px;
      border: none;
      cursor: pointer;
      background: #f3f4f6;
    }

    .toggle .selected {
      background: #2563eb;
      color: white;
    }

    input {
      width: 100%;
      padding: 12px;
      border-radius: 8px;
      border: 1px solid #d1d5db;
      margin-bottom: 10px;
    }

    .primary {
      background: #2563eb;
      color: white;
      border: none;
      padding: 12px;
      width: 100%;
      border-radius: 10px;
      cursor: pointer;
    }

    .primary:hover { background: #1d4ed8; }

    .success {
      margin-top: 10px;
      background: #ecfdf5;
      border: 1px solid #a7f3d0;
      padding: 10px;
      border-radius: 10px;
      color: #047857;
      text-align: center;
    }

    .camera-box {
      background: black;
      color: white;
      border-radius: 12px;
      aspect-ratio: 16 / 9;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
    }

    .samples {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
      gap: 10px;
    }

    .samples button {
      padding: 14px;
      border-radius: 10px;
      border: 1px solid #e5e7eb;
      background: white;
      cursor: pointer;
    }

    .samples button:hover {
      border-color: #2563eb;
      background: #eff6ff;
    }

    @media (max-width: 768px) {
      .sidebar { position: relative; width: 100%; height: auto; }
      .main { margin-left: 0; }
    }
  </style>
</head>
<body>

<?php
    require "Sidebar.php" ;

    ?>

<div class="main">
  <h2>Scan Barcode Pesanan</h2>
  <p>Scan barcode untuk melihat detail pesanan</p>

  <div class="card">
    <div class="toggle">
      <button id="manualBtn" class="selected" onclick="setMode('manual')">Input Manual</button>
      <button id="cameraBtn" onclick="setMode('camera')">Scan Kamera</button>
    </div>

    <div id="manualMode">
      <input id="barcodeInput" placeholder="Masukkan kode barcode (ORD001)" />
      <button class="primary" onclick="scanManual()">Scan Barcode</button>
      <div id="successBox"></div>
    </div>

    <div id="cameraMode" style="display:none">
      <div class="camera-box">
        <p>Arahkan kamera ke barcode</p>
        <small>(Demo mode - gunakan input manual)</small>
      </div>
    </div>
  </div>

  <div class="card">
    <h3>Barcode Contoh</h3>
    <div class="samples">
      <button onclick="fillSample('ORD001')">ORD001</button>
      <button onclick="fillSample('ORD002')">ORD002</button>
      <button onclick="fillSample('ORD003')">ORD003</button>
    </div>
  </div>
</div>

<script>
  function setMode(mode) {
    document.getElementById('manualMode').style.display = mode === 'manual' ? 'block' : 'none';
    document.getElementById('cameraMode').style.display = mode === 'camera' ? 'block' : 'none';

    document.getElementById('manualBtn').classList.toggle('selected', mode === 'manual');
    document.getElementById('cameraBtn').classList.toggle('selected', mode === 'camera');
  }

  function scanManual() {
    const input = document.getElementById('barcodeInput').value.trim();
    const box = document.getElementById('successBox');

    if (!input) return;

    box.innerHTML = `<div class="success">✓ Barcode berhasil discan: <strong>${input}</strong><br/>Mengalihkan...</div>`;

    setTimeout(() => {
      alert("Scan selesai: " + input);
      box.innerHTML = "";
    }, 1000);
  }

  function fillSample(code) {
    document.getElementById('barcodeInput').value = code;
    setMode('manual');
  }

  function logout() {
    alert("Logout berhasil");
  }
</script>

</body>
</html>