<!DOCTYPE html>
<html lang="id">
<head>
  
  <meta charset="UTF-8" />
  <title>Laporan Transaksi</title>
  <style>
    * { box-sizing: border-box; font-family: Arial, sans-serif; }
    body { margin: 0; background: #f5f6f8; color: #1f2933; }

   

    .nav { padding: 10px; flex: 1; }
    .nav button {
      width: 100%;
      padding: 12px;
      border: none;
      background: none;
      text-align: left;
      border-radius: 8px;
      cursor: pointer;
    }

    .nav button:hover { background: #f3f4f6; }
    .nav .active { background: #e0edff; color: #2563eb; }

    .logout {
      padding: 10px;
      border-top: 1px solid #e5e7eb;
    }

    .logout button {
      width: 100%;
      padding: 12px;
      border: none;
      background: none;
      color: #dc2626;
      border-radius: 8px;
      cursor: pointer;
    }

    .logout button:hover { background: #fee2e2; }

    .main {
      margin-left: 260px;
      padding: 30px;
    }

    .card {
      background: white;
      border: 1px solid #e5e7eb;
      border-radius: 14px;
      padding: 20px;
      margin-bottom: 20px;
    }

    select, button {
      padding: 10px;
      border-radius: 8px;
      border: 1px solid #d1d5db;
      cursor: pointer;
    }

    .actions button {
      border: none;
      color: white;
    }

    .btn-green { background: #16a34a; }
    .btn-blue { background: #2563eb; }

    .summary {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 15px;
      margin-bottom: 20px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    th, td {
      padding: 12px;
      border-bottom: 1px solid #e5e7eb;
      text-align: left;
    }

    th { background: #f3f4f6; }
    td.right { text-align: right; }
    td.center { text-align: center; }

    .badge {
      padding: 4px 10px;
      border-radius: 20px;
      font-size: 12px;
    }

    .pending { background: #fef9c3; color: #854d0e; }
    .completed { background: #dcfce7; color: #166534; }

    @media print {
      .sidebar, .filters { display: none; }
      .main { margin: 0; padding: 0; }
    }
  </style>
</head>
<body>

   <?php
    require "Sidebar.php" ;

    ?>

<div class="main">
  <h2>Laporan Transaksi</h2>
  <p class="filters">Generate dan cetak laporan transaksi</p>

  <div class="card filters">
    <label>Filter Status</label>
    <select id="statusFilter" onchange="render()">
      <option value="all">Semua Status</option>
      <option value="pending">Pending</option>
      <option value="completed">Selesai</option>
    </select>

    <div class="actions" style="margin-top:10px;">
      <button class="btn-green" onclick="downloadCSV()">Download CSV</button>
      <button class="btn-blue" onclick="window.print()">Cetak</button>
    </div>
  </div>

  <div class="summary">
    <div class="card">
      <div>Total Transaksi</div>
      <strong id="totalTransaksi">0</strong>
    </div>
    <div class="card">
      <div>Pendapatan Selesai</div>
      <strong id="totalRevenue">Rp 0</strong>
    </div>
    <div class="card">
      <div>Pending Revenue</div>
      <strong id="pendingRevenue">Rp 0</strong>
    </div>
  </div>

  <div class="card">
    <h3>Detail Transaksi</h3>
    <table>
      <thead>
        <tr>
          <th>No. Pesanan</th>
          <th>Tanggal</th>
          <th>Item</th>
          <th>Total</th>
          <th>Status</th>
        </tr>
      </thead>
      <tbody id="tableBody"></tbody>
      <tfoot>
        <tr>
          <td colspan="3"><strong>Total</strong></td>
          <td class="right"><strong id="grandTotal">Rp 0</strong></td>
          <td></td>
        </tr>
      </tfoot>
    </table>
  </div>
</div>

<script>
  const orders = [
    {
      id: 1,
      orderNumber: "ORD001",
      timestamp: Date.now(),
      items: ["Nasi Goreng", "Es Teh"],
      total: 25000,
      status: "completed"
    },
    {
      id: 2,
      orderNumber: "ORD002",
      timestamp: Date.now(),
      items: ["Mie Ayam"],
      total: 15000,
      status: "pending"
    }
  ];

  function formatRupiah(num) {
    return "Rp " + num.toLocaleString("id-ID");
  }

  function render() {
    const filter = document.getElementById("statusFilter").value;

    const filtered = orders.filter(o =>
      filter === "all" ? true : o.status === filter
    );

    const totalRevenue = filtered
      .filter(o => o.status === "completed")
      .reduce((sum, o) => sum + o.total, 0);

    const pendingRevenue = filtered
      .filter(o => o.status === "pending")
      .reduce((sum, o) => sum + o.total, 0);

    document.getElementById("totalTransaksi").innerText = filtered.length;
    document.getElementById("totalRevenue").innerText = formatRupiah(totalRevenue);
    document.getElementById("pendingRevenue").innerText = formatRupiah(pendingRevenue);
    document.getElementById("grandTotal").innerText = formatRupiah(totalRevenue + pendingRevenue);

    const body = document.getElementById("tableBody");
    body.innerHTML = "";

    filtered.forEach(o => {
      const row = `
        <tr>
          <td>${o.orderNumber}</td>
          <td>${new Date(o.timestamp).toLocaleString("id-ID")}</td>
          <td>${o.items.join(", ")}</td>
          <td class="right">${formatRupiah(o.total)}</td>
          <td class="center">
            <span class="badge ${o.status}">
              ${o.status === "completed" ? "Selesai" : "Pending"}
            </span>
          </td>
        </tr>
      `;
      body.innerHTML += row;
    });
  }

  function downloadCSV() {
    const headers = ["No. Pesanan", "Tanggal", "Item", "Total", "Status"];
    const rows = orders.map(o => [
      o.orderNumber,
      new Date(o.timestamp).toLocaleString("id-ID"),
      o.items.join(" | "),
      o.total,
      o.status
    ]);

    const csv = [
      headers.join(","),
      ...rows.map(r => r.join(","))
    ].join("\n");

    const blob = new Blob([csv], { type: "text/csv" });
    const url = URL.createObjectURL(blob);

    const a = document.createElement("a");
    a.href = url;
    a.download = "laporan-transaksi.csv";
    a.click();
  }

  function logout() {
    alert("Logout berhasil");
  }

  render();
</script>

</body>
</html> 