<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Barcode Pesanan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f5f5f5;
    }

    .page {
      max-width: 420px;
      margin: auto;
      background: white;
      min-height: 100vh;
    }

    .header {
      text-align: center;
      color: white;
      padding: 40px 20px;
      background: linear-gradient(135deg, #f59e0b, #d97706);
    }

    .header.paid {
      background: linear-gradient(135deg, #22c55e, #16a34a);
    }

    .check-circle {
      width: 80px;
      height: 80px;
      background: white;
      border-radius: 50%;
      margin: auto;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 40px;
      animation: bounce 1s infinite;
    }

    @keyframes bounce {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-8px); }
    }

    .content {
      padding: 20px;
    }

    .card {
      border: 1px solid #eee;
      border-radius: 16px;
      padding: 16px;
      margin-bottom: 16px;
      background: white;
    }

    .row {
      display: flex;
      justify-content: space-between;
      margin-bottom: 8px;
      font-size: 14px;
    }

    .badge {
      padding: 6px 10px;
      border-radius: 20px;
      font-size: 12px;
    }

    .badge.waiting {
      background: #fef3c7;
      color: #92400e;
    }

    .badge.paid {
      background: #dcfce7;
      color: #166534;
    }

    .barcode-box {
      border: 2px dashed #fca5a5;
      border-radius: 16px;
      padding: 16px;
      text-align: center;
      background: linear-gradient(135deg, #fef2f2, #fff7ed);
    }

    .timer {
      text-align: center;
      font-size: 28px;
      color: red;
      font-weight: bold;
    }

    button {
      width: 100%;
      border: none;
      border-radius: 24px;
      padding: 14px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      margin-top: 10px;
    }

    .primary {
      background: #dc2626;
      color: white;
    }

    .outline {
      background: white;
      color: #dc2626;
      border: 2px solid #dc2626;
    }
  </style>
</head>
<body>

<div class="page">
  <div id="header" class="header">
    <div class="check-circle" id="icon">✓</div>
    <h2 id="title">Pesanan Berhasil!</h2>
    <p id="subtitle">Silakan selesaikan pembayaran Anda</p>
  </div>

  <div class="content">

    <div class="card">
      <div class="row">
        <div>
          <div style="color: gray;">No. Pesanan</div>
          <strong id="orderId"></strong>
        </div>
        <div id="statusBadge" class="badge waiting">Menunggu Pembayaran</div>
      </div>

      <hr />

      <div class="row">
        <span>Metode Pembayaran</span>
        <strong id="paymentMethod"></strong>
      </div>

      <div class="row">
        <span>Total</span>
        <strong style="color: red;" id="total"></strong>
      </div>

      <div class="row" id="paidTimeRow" style="display:none;">
        <span>Waktu Pembayaran</span>
        <strong id="paidTime"></strong>
      </div>
    </div>

    <div id="paymentSection" class="card">
      <h3 style="text-align:center;">Scan QR Code</h3>
      <div class="barcode-box">
        <svg width="160" height="160" viewBox="0 0 200 200">
          <rect x="10" y="10" width="60" height="60" fill="black"/>
          <rect x="130" y="10" width="60" height="60" fill="black"/>
          <rect x="10" y="130" width="60" height="60" fill="black"/>
        </svg>
      </div>

      <div style="margin-top: 15px;">
        <div style="font-size:13px; color: gray;">Batas Waktu Pembayaran</div>
        <div class="timer" id="timer">10:00</div>
      </div>
    </div>

    <div id="barcodeSection" class="card" style="display:none;">
      <h3 style="text-align:center;">Barcode Pesanan</h3>
      <div class="barcode-box">
        <svg width="260" height="80">
          <rect x="10" y="10" width="4" height="60" fill="black"/>
          <rect x="20" y="10" width="2" height="60" fill="black"/>
          <rect x="30" y="10" width="6" height="60" fill="black"/>
        </svg>
        <div style="margin-top:10px;">
          <div style="font-size:12px; color: gray;">Kode Pesanan</div>
          <strong id="barcodeOrderId"></strong>
        </div>
      </div>
    </div>

    <button class="outline" onclick="goHome()">Kembali ke Beranda</button>

  </div>
</div>

<script>
  const order = {
    id: "ORD-123456",
    paymentMethod: { name: "QRIS", type: "qris" },
    total: 75000
  };

  let countdown = 600;
  let isPaid = false;

  function formatTime(seconds) {
    const mins = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return mins + ":" + String(secs).padStart(2, "0");
  }

  function render() {
    document.getElementById("orderId").innerText = order.id;
    document.getElementById("paymentMethod").innerText = order.paymentMethod.name;
    document.getElementById("total").innerText = "Rp " + order.total.toLocaleString("id-ID");
    document.getElementById("barcodeOrderId").innerText = order.id;

    const header = document.getElementById("header");
    const badge = document.getElementById("statusBadge");

    if (isPaid) {
      header.classList.add("paid");
      document.getElementById("title").innerText = "Pembayaran Berhasil!";
      document.getElementById("subtitle").innerText = "Tunjukkan barcode ini ke kasir";

      badge.className = "badge paid";
      badge.innerText = "Siap Diambil";

      document.getElementById("paymentSection").style.display = "none";
      document.getElementById("barcodeSection").style.display = "block";

      document.getElementById("paidTimeRow").style.display = "flex";
      document.getElementById("paidTime").innerText =
        new Date().toLocaleTimeString("id-ID");
    }
  }

  function goHome() {
    alert("Kembali ke Beranda");
  }

  setInterval(() => {
    if (!isPaid && countdown > 0) {
      countdown--;
      document.getElementById("timer").innerText = formatTime(countdown);
    }
  }, 1000);

  setTimeout(() => {
    isPaid = true;
    render();
  }, 5000);

  render();
</script>

</body>
</html>
