

  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f5f5f5;
    }

    .container {
      max-width: 900px;
      margin: auto;
      padding: 20px;
    }

    h2, h3, h4 {
      margin: 0;
    }

    /* ITEM */
    .cart-item {
      background: white;
      border-radius: 16px;
      padding: 12px;
      margin-bottom: 12px;
      border: 1px solid #eee;
      display: flex;
      gap: 12px;
    }

    .cart-item img {
      width: 70px;
      height: 70px;
      border-radius: 12px;
      object-fit: cover;
    }

    .cart-info {
      flex: 1;
    }

    .price {
      color: #dc2626;
      font-weight: bold;
      margin: 6px 0;
    }

    .qty-control {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .qty-btn {
      width: 28px;
      height: 28px;
      border: none;
      background: #f3f4f6;
      border-radius: 8px;
      cursor: pointer;
      font-size: 16px;
    }

    .remove-btn {
      border: none;
      background: none;
      cursor: pointer;
      color: #dc2626;
      font-size: 18px;
    }

    /* SUMMARY */
    .summary {
      background: linear-gradient(135deg, #f9fafb, #f3f4f6);
      border-radius: 16px;
      padding: 16px;
      margin-top: 20px;
    }

    .summary-row {
      display: flex;
      justify-content: space-between;
      margin-bottom: 8px;
      font-size: 14px;
    }

    .total {
      font-size: 20px;
      font-weight: bold;
      color: #dc2626;
    }

    .promo {
      display: flex;
      gap: 8px;
      margin-top: 16px;
    }

    .promo input {
      flex: 1;
      padding: 10px;
      border-radius: 10px;
      border: 1px solid #ddd;
    }

    .promo button {
      background: #dc2626;
      color: white;
      border: none;
      padding: 10px 16px;
      border-radius: 10px;
      cursor: pointer;
    }

    /* EMPTY */
    .empty {
      text-align: center;
      margin-top: 80px;
      color: #6b7280;
    }

    .empty-icon {
      width: 80px;
      height: 80px;
      background: #f3f4f6;
      border-radius: 50%;
      margin: auto;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 30px;
      margin-bottom: 12px;
    }

    /* BOTTOM BAR FIX */
    
.bottom-bar {
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  background: white;
  border-top: 1px solid #eee;
  padding: 15px;
  display: flex;
  justify-content: center;
}

.bottom-bar button {
  width: 414px;
  max-width: 100%;
  border: none;
  padding: 12px;
  border-radius: 30px;
  background: #d32f2f;
  color: white;
  font-weight: bold;
  cursor: pointer;
}

    .checkout-btn {
      width: 100%;
      background: #dc2626;
      color: white;
      border: none;
      padding: 14px;
      border-radius: 999px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
    }

    /* SPACER (PENTING) */
    .spacer {
      height: 70px;
    }

    /* MOBILE TUNING */
    @media (max-width: 600px) {
      .container {
        padding: 16px;
      }

      .cart-item {
        align-items: center;
      }

      .cart-item img {
        width: 60px;
        height: 60px;
      }
    }
  </style>
</head>
<body>

<?php require "nav.php"; ?>
<div class="page">


<div class="container">

  <h2>Keranjang Belanja</h2>

  <div id="cartContainer"></div>

<div class="summary" id="summaryBox">
  <h3>Ringkasan Pesanan</h3>

  <div class="summary-row">
    <strong>Total</strong>
    <span id="total">Rp 0</span>
  </div>
</div>
   

  <div class="spacer"></div>

</div>



<div class="bottom-bar">
  <button class="checkout-btn"  id="payment" onclick="checkout()">
     Lanjut ke Pembayaran
  </button>
</div><script>
function formatRupiah(num) {
  return "Rp " + (Number(num) || 0).toLocaleString("id-ID");
}

function loadCart() {
  fetch("../backend/get_cart.php")
    .then(res => res.json())
    .then(data => {
      console.log("CART DATA:", data); // DEBUG WAJIB
      renderCart(data);
    })
    .catch(err => console.error("Fetch Error:", err));
}
function renderCart(items) {

  const container = document.getElementById("cartContainer");
  const summaryBox = document.getElementById("summaryBox");

  if (!items || !items.length) {
    summaryBox.style.display = "none";
    container.innerHTML = "<h3>Keranjang kosong</h3>";
    document.getElementById("total").innerText = formatRupiah(0);
    return;
  }

  summaryBox.style.display = "block";

  let subtotal = 0;
  let html = "";

  items.forEach(item => {

    const price = Number(item.price) || 0;
    const qty   = Math.max(1, Number(item.qty) || 1);

    subtotal += price * qty;

    const imagePath = item.image
      ? `../uploads/${item.image}`
      : "https://via.placeholder.com/100";

    html += `
      <div class="cart-item">
        <img src="${imagePath}">
        <div class="cart-info">

          <div style="display:flex; justify-content:space-between;">
            <h4>${item.product_name}</h4>
            <button onclick="removeItem(${item.cart_item_id})">🗑️</button>
          </div>

          <div class="price">${formatRupiah(price)}</div>

          <div class="qty-control">
            <button onclick="updateQty(${item.cart_item_id}, -1)"> - </button>
            <strong>${qty}</strong>
            <button onclick="updateQty(${item.cart_item_id}, 1)"> + </button>
          </div>

        </div>
      </div>
    `;
  });

  container.innerHTML = html; // ✅ render sekali saja
  document.getElementById("total").innerText = formatRupiah(subtotal);
}

function updateQty(cartItemId, change) {
  console.log("CLICK:", cartItemId, change);

  if (!cartItemId) {
    alert("cart_item_id undefined");
    return;
  }

  const fd = new FormData();
  fd.append("cart_item_id", cartItemId); // 🔥 HARUS SAMA DENGAN PHP
  fd.append("change", change);

  fetch("../backend/update_cart.php", {
    method: "POST",
    body: fd
  })
  .then(res => res.text())
  .then(result => {
    console.log("SERVER RESPONSE:", result);
    loadCart();
  })
  .catch(err => console.error(err));
}
function removeItem(cartItemId) {

  console.log("REMOVE CLICK:", cartItemId);

  if (!cartItemId) {
    alert("cart_item_id tidak ada / undefined");
    return;
  }

  const ok = confirm("Hapus item dari keranjang?");
  if (!ok) return;

  const fd = new FormData();
  fd.append("cart_item_id", cartItemId);

  fetch("../backend/remove_cart.php", {
    method: "POST",
    body: fd
  })
  .then(res => res.text())
  .then(result => {
    console.log("SERVER RESPONSE:", result);
    loadCart();
  })
  .catch(err => console.error(err));
}

function checkout() {
  window.location.href = "Payment.php";
}

loadCart();
</script>
</body>
</html>