<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Category Page</title>
</head>
<body>
   <?php
session_start();
if(!isset($_SESSION['user_id']) || $_SESSION['role'] != 'customer'){
    header("Location: LoginCustomer.php");
    exit;
}
?>
 <?php
    require "nav.php" ;

    ?>
<div class="page">

  <!-- Category Tabs -->
  <div class="category-tabs">
    <div class="tabs-container">
  <button class="tab active" data-category="">Semua</button>
  <button class="tab" data-category="Makanan">Makanan</button>
  <button class="tab" data-category="Minuman">Minuman</button>
  <button class="tab" data-category="Snack">Snack</button>
  <button class="tab" data-category="Dessert">Dessert</button>
</div>

  </div>

  <!-- Content -->
  <div class="content">
    <p class="menu-count">12 menu tersedia</p>

    <div class="menu-grid" id="menuContainer">

      <!-- Item -->
      <div class="menu-card">
        <div class="menu-image">
           <img src="PATH_GAMBAR">
      </div>

        <div class="menu-info">
         <h4>NAMA PRODUK</h4>

          <div class="rating">
            ⭐ <span>4.8</span>
            <span class="reviews">(120)</span>
          </div>

          <p class="price">Rp HARGA</p>
           <button class="add-btn">＋</button>
        </div>
        
   
      </div>




      

    </div>
  </div>

</div>

</body>
</html>
<style>
    * {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
  font-family: Arial, sans-serif;
}

body {
  background: #f5f5f5;
}

.page {
  max-width: 480px;
  margin: auto;
  background: white;
  min-height: 100vh;
}

/* ===== CATEGORY TABS ===== */

.category-tabs {
  position: sticky;
  top: 0;
  background: white;
  border-bottom: 1px solid #eee;
  padding: 12px;
  z-index: 10;
}

.tabs-container {
  display: flex;
  gap: 8px;
  overflow-x: auto;
}

.tab {
  border: none;
  padding: 8px 14px;
  border-radius: 999px;
  background: #f1f1f1;
  cursor: pointer;
  white-space: nowrap;
  font-size: 14px;
  transition: 0.2s;
}

.tab:hover {
  background: #e5e5e5;
}

.tab.active {
  background: #e53935;
  color: white;
}

/* ===== CONTENT ===== */

.content {
  padding: 16px;
}

.menu-count {
  color: #666;
  margin-bottom: 12px;
  font-size: 14px;
}

/* ===== GRID ===== */

.menu-grid {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 12px;
}

/* ===== CARD ===== */

.menu-card {
  background: white;
  border-radius: 14px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.08);
  overflow: hidden;
  transition: 0.2s;
}

.menu-card:hover {
  box-shadow: 0 4px 12px rgba(0,0,0,0.12);
}

.menu-image {
  width: 100%;
  aspect-ratio: 1 / 1;
  overflow: hidden;
}

.menu-image img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

.menu-info {
  padding: 10px;
}

.menu-info h4 {
  font-size: 14px;
  margin-bottom: 4px;
}

.rating {
  font-size: 12px;
  margin-bottom: 6px;
}

.reviews {
  color: gray;
}

.price {
  color: #e53935;
  font-weight: bold;
  font-size: 14px;
}

/* ===== BUTTON ===== */

.add-btn {
  width: calc(100% - 10px);
  margin: 0 0 -10px 5px;
  border: none;
  background: #e53935;
  color: white;
  padding: 2px;
  border-radius: 10px;
  cursor: pointer;
  font-size: 20px;



}

.add-btn:hover {
  background: #d32f2f;
}

</style><script>
let allProducts = [];
let activeCategory = "";

function loadMenu() {
  fetch("../backend/get_products.php")
    .then(res => res.json())
    .then(products => {
      allProducts = products;
      renderMenu();
    })
    .catch(err => console.error("Error:", err));
}

function renderMenu() {
  const container = document.getElementById("menuContainer");
  container.innerHTML = "";

  allProducts
    .filter(p => !activeCategory || p.category_name === activeCategory)
    .forEach(p => {

      const imagePath = p.image
        ? `../uploads/${p.image}`
        : "https://via.placeholder.com/300x200?text=No+Image";

      container.innerHTML += `
        <div class="menu-card">
          <div class="menu-image">
            <img src="${imagePath}">
          </div>

          <div class="menu-info">
            <h4>${p.product_name} | ${p.product_type}</h4>

            <div class="rating">
              ⭐ <span>4.8</span>
              <span class="reviews">(0)</span>
            </div>

            <p class="price">
              Rp ${Number(p.price).toLocaleString('id-ID')}
            </p>

            <button class="add-btn" onclick="addToCart(${p.product_id})">＋</button>
          </div>
        </div>
      `;
    });
}

function addToCart(productId) {
  const fd = new FormData();
  fd.append("product_id", productId);

  fetch("../backend/add_to_cart.php", {
    method: "POST",
    body: fd
  })
  .then(res => res.text())
  .then(result => {
    console.log(result);

    if (result.includes("SUCCESS")) {
      showToast("Produk masuk keranjang");
    } else {
      showToast(result);
    }
  })
  .catch(err => console.error(err));
}

/* FILTER TAB */
document.querySelectorAll(".tab").forEach(tab => {
  tab.addEventListener("click", function () {
    document.querySelectorAll(".tab").forEach(t => t.classList.remove("active"));
    this.classList.add("active");

    activeCategory = this.dataset.category || "";
    renderMenu();
  });
});

/* TOAST NOTIFICATION (lebih modern dari alert) */
function showToast(message) {
  const toast = document.createElement("div");
  toast.innerText = message;
  toast.style.position = "fixed";
  toast.style.bottom = "20px";
  toast.style.left = "50%";
  toast.style.transform = "translateX(-50%)";
  toast.style.background = "#111";
  toast.style.color = "white";
  toast.style.padding = "10px 18px";
  toast.style.borderRadius = "8px";
  toast.style.zIndex = "9999";
  toast.style.fontSize = "14px";

  document.body.appendChild(toast);

  setTimeout(() => toast.remove(), 2000);
}

loadMenu();
</script>