 <?php
session_start();
if(!isset($_SESSION['user_id']) || $_SESSION['role'] != 'customer'){
    header("Location: LoginCustomer.php");
    exit;
}
?>
 <?php
    require "nav.php" ;

    ?>
    

<div class="page">
    <style>
        .page {
  max-width: 480px;
  margin: auto;
  background: white;
  min-height: 100vh;
}

/* ===== RESPONSIVE FIX ===== */
    @media (max-width: 600px) {
      
      .b{
        margin : 0 0 150px 0;
      }
    }

    </style>

  <!-- HERO -->
  <section class="hero">
    <div class="circle circle1"></div>
    <div class="circle circle2"></div>

    <div class="hero-content">
      <p>Selamat Datang di</p>
      <h2>Legits</h2>
      <span>Kelezatan Nusantara dalam Setiap Sajian</span>
    </div>
  </section>

  <!-- CATEGORIES -->
  <section class="section white">
    <div class="section-header">
      <h3>Kategori</h3>
      <button class="link-btn">Lihat Semua →</button>
    </div>

    <div class="categories">
      <div class="category-item"><div class="icon-circle">🍛</div><span>Makanan</span></div>
      <div class="category-item"><div class="icon-circle">🥤</div><span>Minuman</span></div>
      <div class="category-item"><div class="icon-circle">🍰</div><span>Dessert</span></div>
      <div class="category-item"><div class="icon-circle">🎉</div><span>Promo</span></div>
    </div>
  </section>

  <!-- MENU -->
  <section class="section gray">
    <div class="section-header">
      <h3>Menu Populer</h3>
      <button class="link-btn">Lihat Semua →</button>
    </div>

    <div class="menu-list">
      <div class="menu-card">
      <div class="menu-list" id="popularMenu"></div>

      </div>
    </div>
<br>
   

    
  </section>

  <!-- PROMO (TIDAK AKAN TERTUTUP) -->
  <section class="section b">
    <div class="promo">
      <p>🎉 Promo Spesial</p>
      <h3>Diskon 20%</h3>
      <span>Untuk pemesanan pertama Anda!</span>
    </div>
  </section>
  

</div>

</div>

</body>
</html>
<script>
function loadPopularMenu() {
  fetch("../backend/get_products.php")
    .then(res => res.json())
    .then(products => {
      const container = document.getElementById("popularMenu");
      container.innerHTML = "";

      // ✅ Ambil hanya 3 produk pertama
      const limitedProducts = products.slice(0, 3);

      limitedProducts.forEach(p => {
        const imagePath = p.image
          ? `../uploads/${p.image}`
          : "https://via.placeholder.com/300x200?text=No+Image";

        container.innerHTML += `
          <div class="menu-card">
            <img src="${imagePath}" alt="${p.product_name}">

            <div class="menu-info">
              <h4>${p.product_name}</h4>
              <p>${p.description || ''}</p>

              <div class="price">
                Rp ${Number(p.price).toLocaleString('id-ID')}
              </div>
            </div>
          </div>
        `;
      });
    })
    .catch(err => console.error("Error:", err));
}

loadPopularMenu();
</script>



