<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Login - Legits</title>

  <!-- Font mirip contoh -->
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">

  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
      font-family: 'Inter', sans-serif;
    }

    body {
      min-height: 100vh;
      background: linear-gradient(135deg, #dc2626, #b91c1c, #7f1d1d);
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .container {
      width: 100%;
      max-width: 420px;
      padding: 24px;
    }

    .logo-section {
      text-align: center;
      margin-bottom: 40px;
      color: white;
    }

    .logo-box {
      width: 80px;
      height: 80px;
      background: white;
      border-radius: 24px;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 12px;
      box-shadow: 0 20px 40px rgba(0,0,0,0.25);
    }

    .logo-box span {
      font-family: 'Playfair Display', serif;
      font-size: 32px;
      font-weight: bold;
      color: #dc2626;
    }

    .logo-section h1 {
      font-family: 'Playfair Display', serif;
      font-size: 36px;
      margin-bottom: 4px;
    }

    .logo-section p {
      font-size: 13px;
      color: #fecaca;
    }

    .card {
      background: white;
      border-radius: 28px;
      padding: 28px;
      box-shadow: 0 25px 50px rgba(0,0,0,0.2);
    }

    .card h2 {
      text-align: center;
      margin-bottom: 6px;
    }

    .subtitle {
      text-align: center;
      color: #6b7280;
      font-size: 14px;
      margin-bottom: 20px;
    }

    .form-group {
      margin-bottom: 16px;
    }

    label {
      display: block;
      font-size: 14px;
      font-weight: 500;
      margin-bottom: 6px;
      color: #374151;
    }

    .input-wrapper {
      position: relative;
    }

    input {
      width: 100%;
      padding: 12px 14px 12px 42px;
      border-radius: 12px;
      border: 1px solid #d1d5db;
      font-size: 14px;
      outline: none;
      transition: 0.2s;
    }

    input:focus {
      border-color: #dc2626;
      box-shadow: 0 0 0 2px rgba(220,38,38,0.2);
    }

    .icon {
      position: absolute;
      left: 14px;
      top: 50%;
      transform: translateY(-50%);
      font-size: 16px;
      color: #9ca3af;
    }

    .toggle-password {
      position: absolute;
      right: 12px;
      top: 50%;
      transform: translateY(-50%);
      border: none;
      background: none;
      cursor: pointer;
      font-size: 16px;
      color: #9ca3af;
    }

    .toggle-password:hover {
      color: #374151;
    }

    .forgot {
      text-align: right;
      margin-bottom: 16px;
    }

    .forgot button {
      border: none;
      background: none;
      color: #dc2626;
      font-size: 13px;
      cursor: pointer;
    }

    .forgot button:hover {
      text-decoration: underline;
    }

    .login-btn {
      width: 100%;
      border: none;
      background: #dc2626;
      color: white;
      padding: 12px;
      border-radius: 12px;
      font-weight: 600;
      cursor: pointer;
      transition: 0.2s;
    }

    .login-btn:hover {
      background: #b91c1c;
    }

    .divider {
      text-align: center;
      margin: 20px 0;
      color: #9ca3af;
      font-size: 13px;
      position: relative;
    }

    .divider::before,
    .divider::after {
      content: "";
      position: absolute;
      top: 50%;
      width: 40%;
      height: 1px;
      background: #e5e7eb;
    }

    .divider::before { left: 0; }
    .divider::after { right: 0; }

    .google-btn {
      width: 100%;
      border: 2px solid #e5e7eb;
      background: white;
      padding: 12px;
      border-radius: 12px;
      cursor: pointer;
      font-weight: 500;
    }

    .google-btn:hover {
      border-color: #9ca3af;
    }

    .register {
      text-align: center;
      margin-top: 18px;
      font-size: 14px;
      color: #6b7280;
    }

    .register button {
      border: none;
      background: none;
      color: #dc2626;
      font-weight: 600;
      cursor: pointer;
    }

    .footer {
      text-align: center;
      margin-top: 24px;
      font-size: 12px;
      color: #fecaca;
    }
  </style>
</head>
<body>

  <div class="container">
    <div class="logo-section">
      <div class="logo-box">
        <span>L</span>
      </div>
      <h1>Legits</h1>
      <p>Kelezatan Nusantara dalam Setiap Sajian</p>
    </div>

    <div class="card">
      <h2>Selamat Datang</h2>
      <div class="subtitle">Masuk ke akun Anda</div>

      <form id="loginForm" action="login.php" method="post">
        <div class="form-group">
          <label>Nomor Telepon</label>
          <div class="input-wrapper">
            <span class="icon">📞</span>
            <input type="tel" id="phone" name="phone_number" placeholder="08xxxxxxxxxx" required>
          </div>
        </div>

        <div class="form-group">
          <label>Password</label>
          <div class="input-wrapper">
            <span class="icon">🔒</span>
            <input type="password" id="password" placeholder="Masukkan password" name="password" required>
            <button type="button" class="toggle-password" onclick="togglePassword()">👁️</button>
          </div>
        </div>

        <div class="forgot">
          <button type="button">Lupa Password?</button>
        </div>

        <button class="login-btn" type="submit" name="login">Masuk</button>
      </form>

      <div class="divider">atau</div>

      <button class="google-btn">Masuk dengan Google</button>

      <div class="register">
        Belum punya akun?
        <button id="register">Daftar Sekarang</button>
      </div>
    </div>

    <div class="footer">
      © 2024 Legits. All rights reserved.
    </div>
  </div>



</body>
<script>
  document.getElementById("register").addEventListener("click", function() {
      window.location.href = "Register.php";
  });
</script>
</html>
