
     <?php
    require "nav.php" ;

    ?>

<div class="page">

  <!-- Back Button -->
  <button class="back-btn" onclick="history.back()">←</button>

  <!-- Image -->
  <div class="detail-image">
    <img src="https://picsum.photos/500/400" alt="Menu" />
    <div class="image-overlay"></div>
  </div>

  <!-- Content -->
  <div class="detail-content">
    <div class="header">
      <h2 id="menuName">Nasi Goreng Spesial</h2>
      <div class="price" id="menuPrice">Rp 35.000</div>
    </div>

    <div class="rating-row">
      <div class="rating-badge">⭐ 4.9</div>
      <span class="reviews">(312 ulasan)</span>
    </div>

    <div class="category">Makanan Utama</div>

    <div class="section">
      <h3>Deskripsi</h3>
      <p>
        Nasi goreng dengan bumbu rempah pilihan, telur mata sapi,
        dan topping spesial khas Legits.
      </p>
    </div>

    <div class="section">
      <div class="info-row">
        <span>⏱️</span>
        <div>
          <strong>Waktu Persiapan</strong>
          <p>15–20 menit</p>
        </div>
      </div>

      <div class="info-row">
        <span>🌶️</span>
        <div>
          <strong>Tingkat Pedas</strong>
          <p>Sedang</p>
        </div>
      </div>
    </div>

    <div class="section">
      <h3>Ulasan Pelanggan</h3>

      <div class="review">
        <div class="review-header">
          <strong>Ahmad</strong>
          <span>⭐⭐⭐⭐⭐</span>
        </div>
        <p>Rasanya enak sekali, porsinya juga besar!</p>
      </div>

      <div class="review">
        <div class="review-header">
          <strong>Siti</strong>
          <span>⭐⭐⭐⭐⭐</span>
        </div>
        <p>Pelayanan cepat dan makanan lezat.</p>
      </div>
    </div>
  </div>

</div>

<!-- Bottom Bar -->
<div class="bottom-bar">
  <div class="qty-control">
    <button onclick="decrease()">−</button>
    <span id="qty">1</span>
    <button onclick="increase()">+</button>
  </div>

  <button class="add-cart-btn" onclick="addToCart()">
    Tambah ke Keranjang - <span id="totalPrice">Rp 35.000</span>
  </button>
</div>

<script>
  let price = 35000;
  let quantity = 1;

  function formatRupiah(value) {
    return "Rp " + value.toLocaleString("id-ID");
  }

  function increase() {
    quantity++;
    update();
  }

  function decrease() {
    if (quantity > 1) quantity--;
    update();
  }

  function update() {
    document.getElementById("qty").innerText = quantity;
    document.getElementById("totalPrice").innerText =
      formatRupiah(price * quantity);
  }

  function addToCart() {
    alert("Item ditambahkan ke keranjang: " + quantity + " pcs");
  }
</script>

</body>
<style>
    body {
  margin: 0;
  font-family: Arial, sans-serif;
  background: #f5f5f5;
}

.page {
  max-width: 414px;
  margin: auto;
  background: white;
  min-height: 100vh;
  position: relative;
  padding-bottom: 120px;
}

/* Back Button */
.back-btn {
  position: absolute;
  top: 20px;
  left: 20px;
  z-index: 10;
  border: none;
  background: white;
  width: 40px;
  height: 40px;
  border-radius: 50%;
  box-shadow: 0 4px 10px rgba(0,0,0,0.15);
  cursor: pointer;
  font-size: 18px;
}

/* Image */
.detail-image {
  position: relative;
  height: 280px;
  overflow: hidden;
}

.detail-image img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

.image-overlay {
  position: absolute;
  inset: 0;
  background: linear-gradient(to top, rgba(0,0,0,0.3), transparent);
}

/* Content */
.detail-content {
  margin-top: -20px;
  background: white;
  border-radius: 24px 24px 0 0;
  padding: 20px;
}

.header {
  display: flex;
  justify-content: space-between;
  align-items: start;
}

.price {
  color: #d32f2f;
  font-weight: bold;
  font-size: 18px;
}

.rating-row {
  display: flex;
  align-items: center;
  gap: 10px;
  margin: 10px 0;
}

.rating-badge {
  background: #fff3cd;
  padding: 4px 10px;
  border-radius: 20px;
  font-size: 12px;
}

.reviews {
  font-size: 12px;
  color: gray;
}

.category {
  display: inline-block;
  background: #fdecea;
  color: #d32f2f;
  padding: 4px 10px;
  border-radius: 20px;
  font-size: 12px;
  margin-bottom: 10px;
}

.section {
  margin-top: 20px;
}

.section h3 {
  margin-bottom: 8px;
}

.section p {
  font-size: 13px;
  color: gray;
}

/* Info */
.info-row {
  display: flex;
  gap: 10px;
  margin-bottom: 10px;
}

.review {
  background: #f7f7f7;
  padding: 10px;
  border-radius: 12px;
  margin-bottom: 10px;
}

.review-header {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
}

/* Bottom Bar */
.bottom-bar {
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  background: white;
  border-top: 1px solid #eee;
  padding: 15px;
  display: flex;
  gap: 10px;
  justify-content: center;
}

.qty-control {
  display: flex;
  align-items: center;
  gap: 10px;
  background: #f1f1f1;
  padding: 5px 10px;
  border-radius: 30px;
}

.qty-control button {
  border: none;
  background: white;
  width: 32px;
  height: 32px;
  border-radius: 50%;
  cursor: pointer;
}

.add-cart-btn {
  flex: 1;
  border: none;
  background: #d32f2f;
  color: white;
  border-radius: 30px;
  font-weight: bold;
  cursor: pointer;
}

</style>
</html>
