
<body>
  <?php
    require "nav.php" ;

    ?>
<div class="page">

  <!-- Header -->
  <div class="x">
    <button class="back-btn" onclick="history.back()">←</button>
    <h2>Pilih Pembayaran</h2>
  </div>

  <div class="content">

    <!-- Total -->
    <div class="total-card">
      <p>Total Pembayaran</p>
      <h1 id="totalText">Rp 50.000</h1>
    </div>

    <!-- Filter -->
    <div class="filters">
      <button onclick="setFilter('all')" class="active" id="filter-all">Semua</button>
      <button onclick="setFilter('virtual_account')" id="filter-va">Virtual Account</button>
      <button onclick="setFilter('e-wallet')" id="filter-ewallet">E-Wallet</button>
      <button onclick="setFilter('qris')" id="filter-qris">QRIS</button>
    </div>

    <!-- Methods -->
    <div id="methods" class="methods"></div>

    <!-- Info -->
    <div id="paymentInfo" class="payment-info hidden">
      ℹ️ Setelah konfirmasi, Anda akan diarahkan ke halaman pembayaran
      <span id="selectedName"></span>
    </div>

  </div>

</div>

<!-- Bottom Bar -->
<div class="bottom-bar">
  <button id="confirmBtn" disabled onclick="confirmPayment()">
    Konfirmasi Pembayaran
  </button>
</div>

<script>
  const total = 50000;

  const paymentMethods = [
    { id: 'bca', name: 'BCA Virtual Account', type: 'virtual_account', icon: '🏦' },
    { id: 'mandiri', name: 'Mandiri Virtual Account', type: 'virtual_account', icon: '🏦' },
    { id: 'bni', name: 'BNI Virtual Account', type: 'virtual_account', icon: '🏦' },
    { id: 'qris', name: 'QRIS', type: 'qris', icon: '📱' },
    { id: 'shopeepay', name: 'ShopeePay', type: 'e-wallet', icon: '🛒' },
    { id: 'dana', name: 'DANA', type: 'e-wallet', icon: '💰' },
    { id: 'gopay', name: 'GoPay', type: 'e-wallet', icon: '🚗' },
    { id: 'ovo', name: 'OVO', type: 'e-wallet', icon: '🟣' },
  ];

  let selectedMethod = null;
  let filter = 'all';

  function formatRupiah(value) {
    return "Rp " + value.toLocaleString("id-ID");
  }

  document.getElementById("totalText").innerText = formatRupiah(total);

  function setFilter(type) {
    filter = type;

    document.querySelectorAll(".filters button").forEach(btn => btn.classList.remove("active"));

    if (type === 'all') document.getElementById("filter-all").classList.add("active");
    if (type === 'virtual_account') document.getElementById("filter-va").classList.add("active");
    if (type === 'e-wallet') document.getElementById("filter-ewallet").classList.add("active");
    if (type === 'qris') document.getElementById("filter-qris").classList.add("active");

    renderMethods();
  }

  function renderMethods() {
    const container = document.getElementById("methods");
    container.innerHTML = "";

    const filtered = filter === 'all'
      ? paymentMethods
      : paymentMethods.filter(m => m.type === filter);

    filtered.forEach(method => {
      const div = document.createElement("div");
      div.className = "method-card" + (selectedMethod?.id === method.id ? " selected" : "");

      div.onclick = () => selectMethod(method);

      div.innerHTML = `
        <div class="icon">${method.icon}</div>
        <div class="info">
          <div class="name">${method.name}</div>
          <div class="type">${method.type.replace('_', ' ')}</div>
        </div>
        <div class="check">${selectedMethod?.id === method.id ? "✔" : ""}</div>
      `;

      container.appendChild(div);
    });
  }

  function selectMethod(method) {
    selectedMethod = method;
    document.getElementById("confirmBtn").disabled = false;
    document.getElementById("paymentInfo").classList.remove("hidden");
    document.getElementById("selectedName").innerText = method.name;
    renderMethods();
  }

  function confirmPayment() {
    if (!selectedMethod) return;
    alert("Metode dipilih: " + selectedMethod.name);
  }

  renderMethods();
</script>

</body>
<style>
    body {
  margin: 0;
  font-family: Arial, sans-serif;
  background: #f5f5f5;
}


/* Header */
.x {
  display: flex;
  align-items: center;
  gap: 10px;
  padding: 15px;
  border-bottom: 1px solid #eee;
  position: sticky;
  top: 0;
  background: white;
  z-index: -1;
}

.back-btn {
  border: none;
  background: none;
  font-size: 20px;
  cursor: pointer;
}

/* Content */
.content {
  padding: 15px;
}

/* Total */
.total-card {
  background: linear-gradient(135deg, #d32f2f, #b71c1c);
  color: white;
  padding: 20px;
  border-radius: 16px;
  margin-bottom: 20px;
}

/* Filters */
.filters {
  display: flex;
  gap: 8px;
  overflow-x: auto;
  margin-bottom: 15px;
}

.filters button {
  border: none;
  padding: 8px 14px;
  border-radius: 20px;
  background: #f1f1f1;
  cursor: pointer;
  white-space: nowrap;
}

.filters .active {
  background: #d32f2f;
  color: white;
}

/* Methods */
.methods {
  display: flex;
  flex-direction: column;
  gap: 10px;
}

.method-card {
  display: flex;
  align-items: center;
  gap: 10px;
  border: 2px solid #eee;
  border-radius: 14px;
  padding: 10px;
  cursor: pointer;
  background: white;
}

.method-card.selected {
  border-color: #d32f2f;
  background: #fdecea;
}

.icon {
  width: 40px;
  height: 40px;
  background: #f1f1f1;
  border-radius: 10px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 20px;
}

.info {
  flex: 1;
}

.name {
  font-weight: bold;
  font-size: 14px;
}

.type {
  font-size: 12px;
  color: gray;
}

.check {
  color: #d32f2f;
  font-weight: bold;
}

/* Info */
.payment-info {
  margin-top: 15px;
  background: #fff3cd;
  padding: 10px;
  border-radius: 10px;
  font-size: 12px;
}

.hidden {
  display: none;
}

/* Bottom Bar */
.bottom-bar {
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  background: white;
  border-top: 1px solid #eee;
  padding: 15px;
  display: flex;
  justify-content: center;
}

.bottom-bar button {
  width: 414px;
  max-width: 100%;
  border: none;
  padding: 12px;
  border-radius: 30px;
  background: #d32f2f;
  color: white;
  font-weight: bold;
  cursor: pointer;
}

.bottom-bar button:disabled {
  background: #ccc;
  cursor: not-allowed;
}

</style>
</html>
