<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Profile</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f3f4f6;
    }

    .page {
      max-width: 480px;
      margin: auto;
      background: #f3f4f6;
      min-height: 100vh;
      padding-bottom: 40px;
    }

    /* HEADER */
    .x {
      background: linear-gradient(135deg, #dc2626, #7f1d1d);
      padding: 32px 20px;
      text-align: center;
      color: white;
    }

    .avatar {
      width: 80px;
      height: 80px;
      background: white;
      border-radius: 50%;
      margin: auto;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 32px;
      margin-bottom: 12px;
    }

    /* MENU */
    .menu {
      padding: 20px;
    }

    .menu button {
      width: 100%;
      border: none;
      background: white;
      border-radius: 14px;
      padding: 14px;
      margin-bottom: 12px;
      display: flex;
      align-items: center;
      cursor: pointer;
      box-shadow: 0 4px 10px rgba(0,0,0,0.05);
      transition: 0.2s;
    }

    .menu button:hover {
      background: #f9fafb;
    }

    .icon {
      width: 42px;
      height: 42px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 12px;
      font-size: 18px;
    }

    .blue { background: #eff6ff; }
    .purple { background: #f5f3ff; }
    .green { background: #ecfdf5; }
    .orange { background: #fff7ed; }
    .red { background: #fef2f2; }

    .text {
      flex: 1;
      text-align: left;
    }

    .title {
      font-weight: bold;
      font-size: 14px;
    }

    .subtitle {
      font-size: 12px;
      color: #6b7280;
    }

    .logout {
      border: 2px solid #dc2626 !important;
      color: #dc2626;
    }

    /* MODAL */
    .modal {
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,0.5);
      display: none;
      align-items: center;
      justify-content: center;
    }

    .modal-content {
      background: white;
      border-radius: 16px;
      padding: 20px;
      width: 90%;
      max-width: 380px;
    }

    input {
      width: 100%;
      padding: 10px;
      border-radius: 10px;
      border: 1px solid #ddd;
      margin-top: 6px;
      margin-bottom: 12px;
    }

    .actions {
      display: flex;
      gap: 10px;
    }

    .btn {
      flex: 1;
      padding: 10px;
      border-radius: 10px;
      border: none;
      cursor: pointer;
    }

    .btn-cancel {
      background: #e5e7eb;
    }

    .btn-save {
      background: #dc2626;
      color: white;
    }
  </style>
</head>
<body>
   <?php
    require "nav.php" ;

    ?>

<div class="page">

  <div class=" x" >
    
    <div class="avatar">👤</div>
    <div><strong>Iman Nuel</strong></div>
    <div style="font-size:13px;">08123456789</div>
  </div>

  <div class="menu">

    <button onclick="openModal()">
      <div class="icon blue">📱</div>
      <div class="text">
        <div class="title">Ganti Nomor HP</div>
        <div class="subtitle">Perbarui nomor telepon Anda</div>
      </div>
      ➜
    </button>

    <button>
      <div class="icon purple">🛒</div>
      <div class="text">
        <div class="title">Riwayat Pemesanan</div>
        <div class="subtitle">Lihat pesanan yang telah dibuat</div>
      </div>
      ➜
    </button>

    <button>
      <div class="icon green">❓</div>
      <div class="text">
        <div class="title">Bantuan</div>
        <div class="subtitle">Pusat bantuan dan FAQ</div>
      </div>
      ➜
    </button>

    <button>
      <div class="icon orange">⚙️</div>
      <div class="text">
        <div class="title">Pengaturan Akun</div>
        <div class="subtitle">Kelola informasi akun Anda</div>
      </div>
      ➜
    </button>

    <button class="logout" id="beranda">
      <div class="icon red">🚪</div>
      <div class="text">
        <div class="title">Keluar</div>
        <div class="subtitle">Keluar dari akun Anda</div>
      </div>
    </button>

  </div>
</div>

<!-- MODAL -->
<div class="modal" id="phoneModal">
  <div class="modal-content">
    <h3>Ganti Nomor HP</h3>

    <label>Nomor Saat Ini</label>
    <input type="text" value="08123456789" disabled>

    <label>Nomor Baru</label>
    <input type="tel" placeholder="08xxxxxxxx">

    <div class="actions">
      <button class="btn btn-cancel" onclick="closeModal()">Batal</button>
      <button class="btn btn-save" onclick="closeModal()">Simpan</button>
    </div>
  </div>
</div>

<script>
  function openModal() {
    document.getElementById('phoneModal').style.display = 'flex';
  }

  function closeModal() {
    document.getElementById('phoneModal').style.display = 'none';
  }


    document.getElementById("beranda").addEventListener("click", function() {
      window.location.href = "LoginCustomer.php";
  });
</script>

</body>
</html>