<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Daftar Akun</title>
  <link rel="stylesheet" href="register.css">
</head>
<body>

<div class="page">

  <!-- Back Button -->
  <button class="back-btn" onclick="goBack()">←</button>

  <!-- Header -->
  <div class="header">
    <h1>Daftar Akun</h1>
    <p>Buat akun baru untuk memulai</p>
  </div>

  <!-- Form Card -->
  <div class="card">
   <form action="proses_register.php" method="post">

  <!-- Nama -->
  <label>Nama Lengkap</label>
  <div class="input-group">
    <span class="icon">👤</span>
    <input type="text" name="name" placeholder="Masukkan nama lengkap" required>
  </div>

  <!-- Telepon -->
  <label>Nomor Telepon</label>
  <div class="input-group">
    <span class="icon">📞</span>
    <input type="tel" name="phone_number" placeholder="08xxxxxxxxxx" required>
  </div>
  
 <!-- Email -->
<label>Email</label>
<div class="input-group">
  <span class="icon">📧</span>
  <input type="email" name="email" placeholder="Masukkan email" required>
</div>

 <!-- Role -->
 
  <select name="role" required hidden>
    <option value="customer">Customer</option>
  </select>


  <!-- Password -->
  <label>Password</label>
  <div class="input-group">
    <span class="icon">🔒</span>
    <input type="password" name="password" placeholder="Minimal 6 karakter" minlength="6" required>
  </div>

  <!-- Konfirmasi Password -->
  <label>Konfirmasi Password</label>
  <div class="input-group">
    <span class="icon">🔒</span>
    <input type="password" name="confirm_password" placeholder="Ulangi password" required>
  </div>

  <div class="terms">
    <input type="checkbox" name="terms" required>
    <label>Saya setuju dengan Syarat & Ketentuan</label>
  </div>

  <button class="primary-btn" type="submit" name="Register">
    Daftar Sekarang
  </button>

</form>


    <div class="divider">
      <span>atau</span>
    </div>

    <button class="google-btn">
      Daftar dengan Google
    </button>

    <p class="login-text">
      Sudah punya akun?
      <span class="link" onclick="goBack()">Masuk</span>
    </p>
  </div>

  <p class="footer">© 2024 Legits. All rights reserved.</p>

</div>

<script>
  function goBack() {
    history.back();
  }

  function togglePassword(id) {
    const input = document.getElementById(id);
    input.type = input.type === "password" ? "text" : "password";
  }

  function handleRegister(e) {
    e.preventDefault();

    const name = document.getElementById("name").value;
    const phone = document.getElementById("phone").value;
    const password = document.getElementById("password").value;
    const confirmPassword = document.getElementById("confirmPassword").value;
    const agreed = document.getElementById("terms").checked;

    if (password !== confirmPassword) {
      alert("Password tidak cocok!");
      return;
    }

    if (!agreed) {
      alert("Harap setujui syarat dan ketentuan!");
      return;
    }

    alert("Registrasi berhasil untuk: " + name);
  }
</script>

</body>
<style>
    body {
  margin: 0;
  font-family: Arial, sans-serif;
  background: linear-gradient(135deg, #d32f2f, #b71c1c);
  display: flex;
  justify-content: center;
}

.page {
  width: 414px;
  max-width: 100%;
  min-height: 100vh;
  padding: 20px;
  box-sizing: border-box;
  color: white;
}

.back-btn {
  border: none;
  background: rgba(255,255,255,0.2);
  color: white;
  border-radius: 50%;
  width: 40px;
  height: 40px;
  font-size: 20px;
  cursor: pointer;
}

.header {
  text-align: center;
  margin: 20px 0;
}

.card {
  background: white;
  color: black;
  border-radius: 24px;
  padding: 20px;
}

label {
  font-size: 13px;
  display: block;
  margin-top: 10px;
  margin-bottom: 5px;
}

.input-group {
  display: flex;
  align-items: center;
  border: 1px solid #ddd;
  border-radius: 12px;
  padding: 8px;
  margin-bottom: 10px;
}

.input-group input {
  flex: 1;
  border: none;
  outline: none;
  font-size: 14px;
}

.icon {
  margin: 0 6px;
}

.eye-btn {
  border: none;
  background: none;
  cursor: pointer;
}

.terms {
  display: flex;
  gap: 8px;
  font-size: 12px;
  margin: 10px 0;
}

.primary-btn {
  width: 100%;
  border: none;
  background: #d32f2f;
  color: white;
  padding: 12px;
  border-radius: 12px;
  font-weight: bold;
  cursor: pointer;
}

.divider {
  text-align: center;
  margin: 15px 0;
  font-size: 12px;
  color: gray;
}

.google-btn {
  width: 100%;
  padding: 12px;
  border-radius: 12px;
  border: 1px solid #ccc;
  background: white;
  cursor: pointer;
}

.link {
  color: #d32f2f;
  cursor: pointer;
}

.login-text {
  text-align: center;
  font-size: 13px;
}

.footer {
  text-align: center;
  font-size: 12px;
  margin-top: 20px;
  opacity: 0.8;
}

</style>
</html>
