<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Legits UI</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600&display=swap" rel="stylesheet">

  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
      font-family: Arial, sans-serif;
    }

    body {
      background: #f5f5f5;
    }

 .page{
    max-width: 480px;
  margin: auto;
  background: white;
  min-height: 100vh;
 }

    /* ===== HEADER ===== */
    .headerX {
      position: sticky;
      top: 0;
      background: white;
      border-bottom: 1px solid #e5e5e5;
      padding: 14px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      z-index: 1000;
      flex-wrap: wrap;
      gap: 10px;
    }

    .header-left {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .logo-box {
      width: 34px;
      height: 34px;
      border-radius: 10px;
      background: linear-gradient(135deg, #e53935, #8e0000);
      color: white;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: bold;
    }

    .logo-text {
      font-size: 22px;
      font-family: 'Playfair Display', serif;
    }

    .header-nav {
      display: flex;
      gap: 6px;
      flex-wrap: wrap;
    }

    .nav-link {
      border: none;
      background: none;
      padding: 8px 12px;
      border-radius: 10px;
      cursor: pointer;
      font-size: 14px;
      color: #555;
      position: relative;
    }

    .nav-link:hover {
      background: #f5f5f5;
    }

    .nav-link.active {
      color: #e53935;
      font-weight: bold;
    }

    .badge {
      position: absolute;
      top: 2px;
      right: 4px;
      background: #e53935;
      color: white;
      font-size: 10px;
      min-width: 16px;
      height: 16px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    /* ===== HERO ===== */
    .hero {
      position: relative;
      background: linear-gradient(135deg, #d32f2f, #b71c1c);
      color: white;
      overflow: hidden;
    }

    .circle {
      position: absolute;
      border-radius: 50%;
      opacity: 0.15;
    }

    .circle1 {
      width: 200px;
      height: 200px;
      background: yellow;
      top: -60px;
      right: -60px;
    }

    .circle2 {
      width: 140px;
      height: 140px;
      background: orange;
      bottom: -40px;
      left: -40px;
    }

    .hero-content {
      position: relative;
      padding: 20px;
    }

    .hero-content h2 {
      margin: 5px 0;
    }

    /* ===== SECTION ===== */
    .section {
      padding: 20px;
     
    }

    .white { background: white; }
    .gray { background: #f7f7f7; }

    .section-header {
      display: flex;
      justify-content: space-between;
      margin-bottom: 15px;
    }

    .link-btn {
      border: none;
      background: none;
      color: #d32f2f;
      cursor: pointer;
    }

    /* ===== CATEGORIES ===== */
    .categories {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(80px, 1fr));
      gap: 10px;
      text-align: center;
    }

    .icon-circle {
      width: 48px;
      height: 48px;
      margin: auto;
      border-radius: 50%;
      background: linear-gradient(135deg, #fff5f5, #fff0c2);
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 22px;
    }

    .category-item span {
      font-size: 12px;
    }

    /* ===== MENU ===== */
    .menu-list {
      display: flex;
      flex-direction: column;
      gap: 12px;
    }

    .menu-card {
      display: flex;
      background: white;
      border-radius: 14px;
      padding: 10px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.08);
    }

    .menu-card img {
      width: 80px;
      height: 80px;
      border-radius: 10px;
      object-fit: cover;
      margin-right: 10px;
    }

    .menu-info h4 {
      font-size: 14px;
      margin-bottom: 4px;
    }

    .menu-info p {
      font-size: 12px;
      color: gray;
      margin-bottom: 6px;
    }

    .price {
      color: #d32f2f;
      font-weight: bold;
    }

    /* ===== PROMO ===== */
    .promo {
      background: linear-gradient(90deg, #fbc02d, #f9a825);
      border-radius: 16px;
      padding: 20px;
      text-align: center;
      margin-top: 10px;
    }

    .promo h3 {
      color: white;
      margin: 6px 0;
    }

    /* ===== RESPONSIVE FIX ===== */
    @media (max-width: 600px) {
      .header {
        flex-direction: column;
        align-items: flex-start;
      }

      .hero {
        height: auto;
        padding-bottom: 20px;
      }

      .menu-card {
        flex-direction: row;
      }
     
    }
  </style>
</head>

<body>

<div class="page">

  <!-- HEADER -->
  <header class="headerX">
    <div class="header-left">
      <div class="logo-box">L</div>
      <h1 class="logo-text">Legits</h1>
    </div>

    <nav class="header-nav">
      <button class="nav-link active" id="beranda">Beranda</button>
      <button class="nav-link" id="menu">Menu</button>
      <button class="nav-link" id="keranjang">
        Keranjang
        <span class="badge">2</span>
      </button>
      <button class="nav-link"id="profil">Profil</button>
    </nav>
  </header>

  <script defer>
  document.getElementById("menu").addEventListener("click", function() {
      window.location.href = "CategotyPage.php";
  });

   document.getElementById("beranda").addEventListener("click", function() {
      window.location.href = "HomePage.php";
  });

  document.getElementById("keranjang").addEventListener("click", function() {
      window.location.href = "CartPage.php";
  });

  document.getElementById("profil").addEventListener("click", function() {
      window.location.href = "Profillpage.php";
  });
</script>