<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../conn.php';

/* ================= VALIDASI INPUT ================= */

if (!$conn) {
    die("Database connection failed");
}

$name     = $_POST['product_name'] ?? '';
$price    = $_POST['price'] ?? 0;
$category = $_POST['category_id'] ?? 0;
$type     = $_POST['product_type'] ?? '';
$desc     = $_POST['description'] ?? '';
$stock    = $_POST['stock'] ?? 0;
$status   = $_POST['status'] ?? 'ready';

if (empty($name)) {
    die("ERROR: Nama produk wajib diisi");
}

/* ================= HANDLE UPLOAD ================= */

$imageName = "";

if (!empty($_FILES['image']['name'])) {

    if ($_FILES['image']['error'] !== 0) {
        die("ERROR: Upload gambar gagal");
    }

    $imageName = time() . "_" . basename($_FILES['image']['name']);
    $targetPath = "../uploads/" . $imageName;

    if (!move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
        die("ERROR: Gagal menyimpan gambar");
    }
}

/* ================= INSERT DATABASE ================= */

$stmt = $conn->prepare("INSERT INTO products
(product_name, price, category_id, product_type, description, image, stock, status)
VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

if (!$stmt) {
    die("SQL ERROR (prepare): " . $conn->error);
}

$stmt->bind_param(
    "sdisssis",
    $name,
    $price,
    $category,
    $type,
    $desc,
    $imageName,
    $stock,
    $status
);

if ($stmt->execute()) {
    echo "SUCCESS";
} else {
    die("SQL ERROR (execute): " . $stmt->error);
}

$stmt->close();
$conn->close();
