<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Dashboard Statistik</title>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f3f4f6;
    }

    .container {
      max-width: 1200px;
      margin: auto;
      padding: 24px;
    }

    h2 {
      margin-bottom: 20px;
    }

    .grid {
      display: grid;
      gap: 16px;
    }

    .grid-4 {
      grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
      margin-bottom: 24px;
    }

    .grid-2 {
      grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
      margin-bottom: 24px;
    }

    .card {
      background: white;
      border-radius: 12px;
      padding: 16px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.08);
    }

    .stat-title {
      font-size: 14px;
      color: gray;
    }

    .stat-value {
      font-size: 22px;
      margin: 6px 0;
    }

    .positive {
      color: green;
      font-size: 14px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    th, td {
      padding: 10px;
      border-bottom: 1px solid #eee;
      text-align: left;
    }

    th {
      color: gray;
      font-weight: normal;
    }

    canvas {
      max-height: 300px;
    }
  </style>
</head>

<body>

 <?php
    require "Sidebar.php" ;

    ?>
  <div class="container">
    <h2>Dashboard Statistik</h2>

    <!-- Stats Cards -->
    <div class="grid grid-4">
      <div class="card">
        <div class="stat-title">Total Penjualan</div>
        <div class="stat-value">Rp 34.6M</div>
        <div class="positive">📈 +12.5% dari bulan lalu</div>
      </div>

      <div class="card">
        <div class="stat-title">Total Transaksi</div>
        <div class="stat-value">938</div>
        <div class="positive">📈 +8.2% dari bulan lalu</div>
      </div>

      <div class="card">
        <div class="stat-title">Total User</div>
        <div class="stat-value">2,456</div>
        <div class="positive">📈 +18.3% dari bulan lalu</div>
      </div>

      <div class="card">
        <div class="stat-title">Rata-rata Transaksi</div>
        <div class="stat-value">Rp 368K</div>
        <div class="positive">📈 +4.1% dari bulan lalu</div>
      </div>
    </div>

    <!-- Charts -->
    <div class="grid grid-2">
      <div class="card">
        <h3>Grafik Penjualan (6 Bulan Terakhir)</h3>
        <canvas id="salesChart"></canvas>
      </div>

      <div class="card">
        <h3>Jumlah Transaksi</h3>
        <canvas id="trxChart"></canvas>
      </div>
    </div>

    <!-- Table -->
    <div class="card">
      <h3>Produk Terlaris</h3>
      <table>
        <thead>
          <tr>
            <th>Produk</th>
            <th>Terjual</th>
            <th>Revenue</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>Smartphone XYZ</td>
            <td>234 unit</td>
            <td>Rp 45.000.000</td>
          </tr>
          <tr>
            <td>Laptop ABC</td>
            <td>156 unit</td>
            <td>Rp 78.000.000</td>
          </tr>
          <tr>
            <td>Headphone Pro</td>
            <td>445 unit</td>
            <td>Rp 22.250.000</td>
          </tr>
          <tr>
            <td>Smartwatch S1</td>
            <td>321 unit</td>
            <td>Rp 32.100.000</td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>

  <script>
    const labels = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun'];

    const salesData = [4500000, 5200000, 4800000, 6100000, 7200000, 6800000];
    const trxData = [120, 145, 132, 168, 195, 178];

    new Chart(document.getElementById('salesChart'), {
      type: 'line',
      data: {
        labels: labels,
        datasets: [{
          label: 'Penjualan (Rp)',
          data: salesData
        }]
      }
    });

    new Chart(document.getElementById('trxChart'), {
      type: 'bar',
      data: {
        labels: labels,
        datasets: [{
          label: 'Transaksi',
          data: trxData
        }]
      }
    });
  </script>
</body>
</html>