<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Kelola Data User</title>
  <body>
   
  <style>

    body {
      font-family: Arial, sans-serif;
      background: #f3f4f6;
      margin: 0;
      padding: 0;
    }

  

    h2 {
      margin: 0;
      color: #111827;
    }

    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
    }

    button {
      border: none;
      padding: 10px 14px;
      border-radius: 6px;
      cursor: pointer;
      font-size: 14px;
    }

    .btn-primary {
      background: #2563eb;
      color: white;
    }

    .btn-primary:hover {
      background: #1d4ed8;
    }

    .search {
      margin-bottom: 16px;
    }

    input, select {
      width: 100%;
      padding: 10px;
      border-radius: 6px;
      border: 1px solid #d1d5db;
      font-size: 14px;
      box-sizing: border-box;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    th, td {
      padding: 12px;
      border-bottom: 1px solid #e5e7eb;
      text-align: left;
      font-size: 14px;
    }

    th {
      color: #6b7280;
      font-weight: 600;
    }

    .badge {
      padding: 4px 10px;
      border-radius: 999px;
      font-size: 12px;
      display: inline-block;
    }

    .active {
      background: #dcfce7;
      color: #166534;
    }

    .inactive {
      background: #e5e7eb;
      color: #374151;
    }

    .actions button {
      background: none;
      padding: 4px 6px;
      cursor: pointer;
      font-size: 16px;
    }

    .actions button:hover {
      background: #f3f4f6;
    }

    /* Modal */
    .modal {
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,0.4);
      display: none;
      justify-content: center;
      align-items: center;
    }

    .modal-content {
      background: white;
      padding: 20px;
      border-radius: 10px;
      width: 400px;
      max-width: 90%;
    }

    .modal-header {
      font-weight: bold;
      margin-bottom: 12px;
    }

    .modal-footer {
      display: flex;
      justify-content: flex-end;
      gap: 10px;
      margin-top: 16px;
    }

    .hidden {
      display: none;
    }
  </style>
</head>
<body>
     <?php
    require "Sidebar.php" ;

    ?>

<div class="container">
  <div class="header">
    <h2>Kelola Data User</h2>
    <button class="btn-primary" onclick="openAddDialog()">+ Tambah User</button>
  </div>

  <div class="search">
    <input
      type="text"
      id="searchInput"
      placeholder="Cari user berdasarkan nama, email, atau telepon..."
      oninput="renderTable()"
    />
  </div>

  <table>
    <thead>
      <tr>
        <th>Nama</th>
        <th>Email</th>
        <th>Telepon</th>
        <th>Tgl Gabung</th>
        <th>Total Belanja</th>
        <th>Status</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody id="userTable"></tbody>
  </table>

  <div id="emptyState" class="hidden" style="text-align:center; padding:20px; color:#6b7280;">
    Tidak ada user ditemukan
  </div>
</div>

<!-- Add/Edit Modal -->
<div class="modal" id="formModal">
  <div class="modal-content">
    <div class="modal-header" id="modalTitle">Tambah User</div>

    <div>
      <label>Nama</label>
      <input type="text" id="nameInput" />
    </div>

    <div>
      <label>Email</label>
      <input type="email" id="emailInput" />
    </div>

    <div>
      <label>Telepon</label>
      <input type="text" id="phoneInput" />
    </div>

    <div>
      <label>Status</label>
      <select id="statusInput">
        <option value="active">Aktif</option>
        <option value="inactive">Nonaktif</option>
      </select>
    </div>

    <div class="modal-footer">
      <button onclick="closeModal()">Batal</button>
      <button class="btn-primary" onclick="saveUser()">Simpan</button>
    </div>
  </div>
</div>

<!-- View Modal -->
<div class="modal" id="viewModal">
  <div class="modal-content">
    <div class="modal-header">Detail User</div>
    <div id="viewContent"></div>

    <div class="modal-footer">
      <button onclick="closeView()">Tutup</button>
    </div>
  </div>
</div>

<script>
  let users = [
    { id: 1, name: 'Ahmad Fauzi', email: 'ahmad@email.com', phone: '081234567890', joinDate: '2024-01-15', totalSpent: 4500000, status: 'active', totalTransactions: 12 },
    { id: 2, name: 'Siti Nurhaliza', email: 'siti@email.com', phone: '081298765432', joinDate: '2024-02-20', totalSpent: 3200000, status: 'active', totalTransactions: 8 },
    { id: 3, name: 'Budi Santoso', email: 'budi@email.com', phone: '081356789012', joinDate: '2024-03-10', totalSpent: 5800000, status: 'active', totalTransactions: 15 },
    { id: 4, name: 'Dewi Lestari', email: 'dewi@email.com', phone: '081423456789', joinDate: '2024-01-25', totalSpent: 2100000, status: 'inactive', totalTransactions: 5 },
  ];

  let editingUserId = null;

  function formatCurrency(value) {
    return new Intl.NumberFormat('id-ID', {
      style: 'currency',
      currency: 'IDR'
    }).format(value);
  }

  function renderTable() {
    const search = document.getElementById('searchInput').value.toLowerCase();
    const tbody = document.getElementById('userTable');
    const empty = document.getElementById('emptyState');

    const filtered = users.filter(u =>
      u.name.toLowerCase().includes(search) ||
      u.email.toLowerCase().includes(search) ||
      u.phone.includes(search)
    );

    tbody.innerHTML = '';

    if (filtered.length === 0) {
      empty.classList.remove('hidden');
      return;
    }

    empty.classList.add('hidden');

    filtered.forEach(user => {
      tbody.innerHTML += `
        <tr>
          <td>${user.name}</td>
          <td>${user.email}</td>
          <td>${user.phone}</td>
          <td>${new Date(user.joinDate).toLocaleDateString('id-ID')}</td>
          <td>${formatCurrency(user.totalSpent)}</td>
          <td><span class="badge ${user.status}">${user.status === 'active' ? 'Aktif' : 'Nonaktif'}</span></td>
          <td class="actions">
            <button onclick="viewUser(${user.id})">👁</button>
            <button onclick="editUser(${user.id})">✏</button>
            <button onclick="deleteUser(${user.id})">🗑</button>
          </td>
        </tr>
      `;
    });
  }

  function openAddDialog() {
    editingUserId = null;
    document.getElementById('modalTitle').innerText = 'Tambah User';
    document.getElementById('nameInput').value = '';
    document.getElementById('emailInput').value = '';
    document.getElementById('phoneInput').value = '';
    document.getElementById('statusInput').value = 'active';
    document.getElementById('formModal').style.display = 'flex';
  }

  function editUser(id) {
    const user = users.find(u => u.id === id);
    editingUserId = id;

    document.getElementById('modalTitle').innerText = 'Edit User';
    document.getElementById('nameInput').value = user.name;
    document.getElementById('emailInput').value = user.email;
    document.getElementById('phoneInput').value = user.phone;
    document.getElementById('statusInput').value = user.status;

    document.getElementById('formModal').style.display = 'flex';
  }

  function saveUser() {
    const name = document.getElementById('nameInput').value;
    const email = document.getElementById('emailInput').value;
    const phone = document.getElementById('phoneInput').value;
    const status = document.getElementById('statusInput').value;

    if (!name || !email) {
      alert('Nama dan Email wajib diisi');
      return;
    }

    if (editingUserId) {
      const user = users.find(u => u.id === editingUserId);
      user.name = name;
      user.email = email;
      user.phone = phone;
      user.status = status;
    } else {
      const newUser = {
        id: Math.max(...users.map(u => u.id)) + 1,
        name, email, phone, status,
        joinDate: new Date().toISOString().split('T')[0],
        totalSpent: 0,
        totalTransactions: 0
      };
      users.push(newUser);
    }

    closeModal();
    renderTable();
  }

  function deleteUser(id) {
    if (confirm('Yakin hapus user ini?')) {
      users = users.filter(u => u.id !== id);
      renderTable();
    }
  }

  function viewUser(id) {
    const user = users.find(u => u.id === id);
    document.getElementById('viewContent').innerHTML = `
      <p><strong>Nama:</strong> ${user.name}</p>
      <p><strong>Email:</strong> ${user.email}</p>
      <p><strong>Telepon:</strong> ${user.phone}</p>
      <p><strong>Tgl Gabung:</strong> ${new Date(user.joinDate).toLocaleDateString('id-ID')}</p>
      <p><strong>Total Transaksi:</strong> ${user.totalTransactions}</p>
      <p><strong>Total Belanja:</strong> ${formatCurrency(user.totalSpent)}</p>
    `;
    document.getElementById('viewModal').style.display = 'flex';
  }

  function closeModal() {
    document.getElementById('formModal').style.display = 'none';
  }

  function closeView() {
    document.getElementById('viewModal').style.display = 'none';
  }

  renderTable();
</script>

</body>
</html>