<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Sidebar Dashboard</title>

  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      display: flex;
      background: #f3f4f6;
    }
      .container {
      width: 100% ;
      margin: 40px ;
      background: white;
      border-radius: 10px;
      padding: 14px;
      box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    }

    .sidebar {
      width: 260px;
      background: white;
      border-right: 1px solid #e5e7eb;
      height: 100vh;
      display: flex;
      flex-direction: column;
    }

    .sidebar-header {
      padding: 24px;
      border-bottom: 1px solid #e5e7eb;
    }

    .sidebar-header img {
      height: 60px;
      margin-bottom: 8px;
    }

    .sidebar-header p {
      margin: 0;
      font-size: 13px;
      color: #6b7280;
    }

    .menu {
      flex: 1;
      padding: 16px;
    }

    .menu button {
      width: 100%;
      border: none;
      background: none;
      padding: 12px;
      margin-bottom: 6px;
      border-radius: 10px;
      cursor: pointer;
      display: flex;
      align-items: center;
      gap: 10px;
      font-size: 14px;
      color: #374151;
      transition: 0.2s;
    }

    .menu button:hover {
      background: #f9fafb;
    }

    .menu button.active {
      background: #fef2f2;
      color: #dc2626;
      font-weight: bold;
    }

    .icon {
      width: 22px;
      text-align: center;
    }

    .logout {
      padding: 16px;
      border-top: 1px solid #e5e7eb;
    }

    .logout button {
      width: 100%;
      border: none;
      background: none;
      padding: 12px;
      border-radius: 10px;
      cursor: pointer;
      display: flex;
      align-items: center;
      gap: 10px;
      font-size: 14px;
      color: #374151;
    }

    .logout button:hover {
      background: #f9fafb;
    }

    .content {
      flex: 1;
      padding: 40px;
    }
  </style>
</head>
<body>

  <div class="sidebar">
    <div class="sidebar-header">
      <!-- Ganti src logo sesuai file kamu -->
      <img src="logo.png" alt="Legits Logo" />
      <p>Owner Dashboard</p>
    </div>

    <div class="menu">
      <button  id="dashboard" class="active">
        <span class="icon">📊</span>
        Dashboard
      </button>

      <button  id="user">
        <span class="icon">👥</span>
        Manajemen User
      </button>

      <button id="trans">
        <span class="icon">📄</span>
        Laporan Transaksi
      </button>
    </div>

    <div class="logout">
      <button id="logout">
        <span class="icon">🚪</span>
        Logout
      </button>
    </div>
  </div>



  <script>
    

  

    document.getElementById('user').addEventListener("click", function() {
      window.location.href =  "Datausers.php";
  });
      

      
        document.getElementById('dashboard').addEventListener("click", function() {
      window.location.href = "Dashboardstats.php";
  });
      
      document.getElementById('trans').addEventListener("click", function() {
      window.location.href = "Transactionreport.php";
  });
  
document.getElementById("logout").addEventListener("click", function() {
      window.location.href = "../Customer/LoginCustomer.php";
  });
   
  </script>

</body>
</html>