<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Laporan Transaksi</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f3f4f6;
     
    }

 

    h2 {
      margin-bottom: 20px;
    }

    .header {
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      gap: 10px;
      margin-bottom: 20px;
    }

    .btn {
      padding: 10px 14px;
      border-radius: 6px;
      border: none;
      cursor: pointer;
      font-size: 14px;
    }

    .btn-print {
      background: #2563eb;
      color: white;
    }

    .btn-export {
      background: white;
      border: 1px solid #ddd;
    }

    .cards {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 12px;
      margin-bottom: 20px;
    }

    .card {
      background: white;
      padding: 16px;
      border-radius: 10px;
      border: 1px solid #eee;
    }

    .muted {
      color: gray;
      font-size: 13px;
    }

    .filters {
      background: white;
      padding: 16px;
      border-radius: 10px;
      border: 1px solid #eee;
      margin-bottom: 20px;
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
      gap: 10px;
    }

    input, select {
      padding: 10px;
      border-radius: 6px;
      border: 1px solid #ddd;
      width: 100%;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background: white;
      border-radius: 10px;
      overflow: hidden;
    }

    th, td {
      padding: 10px;
      border-bottom: 1px solid #eee;
      text-align: left;
      font-size: 14px;
    }

    th {
      background: #f9fafb;
    }

    .status {
      padding: 4px 8px;
      border-radius: 12px;
      font-size: 12px;
      font-weight: bold;
    }

    .completed { background: #d1fae5; color: #065f46; }
    .pending { background: #fef3c7; color: #92400e; }
    .cancelled { background: #fee2e2; color: #991b1b; }

    .empty {
      text-align: center;
      padding: 20px;
      color: gray;
      background: white;
    }
  </style>
</head>

<body>
     <?php
    require "Sidebar.php" ;

    ?>
<div class="container">

  <div class="header">
    <h2>Laporan Transaksi</h2>
    <div>
      <button class="btn btn-export" onclick="exportCSV()">Export CSV</button>
      <button class="btn btn-print" onclick="printReport()">Cetak Laporan</button>
    </div>
  </div>

  <div class="cards">
    <div class="card">
      <div class="muted">Total Transaksi</div>
      <h3 id="totalTransactions">0</h3>
    </div>
    <div class="card">
      <div class="muted">Transaksi Selesai</div>
      <h3 id="completedTransactions">0</h3>
    </div>
    <div class="card">
      <div class="muted">Total Revenue</div>
      <h3 id="totalRevenue">Rp 0</h3>
    </div>
  </div>

  <div class="filters">
    <input type="text" id="search" placeholder="Cari transaksi...">
    <select id="statusFilter">
      <option value="all">Semua Status</option>
      <option value="completed">Selesai</option>
      <option value="pending">Pending</option>
      <option value="cancelled">Dibatalkan</option>
    </select>
    <input type="date" id="dateFrom">
    <input type="date" id="dateTo">
  </div>

  <div id="tableContainer"></div>

</div>

<script>
const transactions = [
  { id:'TRX-001', date:'2024-12-01', customerName:'Ahmad Fauzi', products:'Dimsum Original', quantity:2, total:56000, status:'completed', paymentMethod:'E-Wallet' },
  { id:'TRX-002', date:'2024-12-02', customerName:'Siti Nurhaliza', products:'Dimsum Mentai Original', quantity:1, total:33000, status:'completed', paymentMethod:'Qris' },
  { id:'TRX-003', date:'2024-12-02', customerName:'Budi Santoso', products:'Dimsum Hot Dragon', quantity:2, total:74000, status:'pending', paymentMethod:'E-Wallet' },
  { id:'TRX-004', date:'2024-12-03', customerName:'Dewi Lestari', products:'Dimsum Spicy Bomb', quantity:1, total:36000, status:'completed', paymentMethod:'Qris' },
  { id:'TRX-005', date:'2024-12-04', customerName:'Fitri', products:'Dismum Original', quantity:1, total:28000, status:'cancelled', paymentMethod:'Qris' }
];

function formatRupiah(num){
  return new Intl.NumberFormat('id-ID', { style:'currency', currency:'IDR', minimumFractionDigits:0 }).format(num);
}

function getFiltered(){
  const search = document.getElementById('search').value.toLowerCase();
  const status = document.getElementById('statusFilter').value;
  const from = document.getElementById('dateFrom').value;
  const to = document.getElementById('dateTo').value;

  return transactions.filter(trx=>{
    const matchSearch =
      trx.id.toLowerCase().includes(search) ||
      trx.customerName.toLowerCase().includes(search) ||
      trx.products.toLowerCase().includes(search);

    const matchStatus = status === 'all' || trx.status === status;
    const matchFrom = !from || trx.date >= from;
    const matchTo = !to || trx.date <= to;

    return matchSearch && matchStatus && matchFrom && matchTo;
  });
}

function render(){
  const data = getFiltered();
  const container = document.getElementById('tableContainer');

  document.getElementById('totalTransactions').innerText = data.length;
  document.getElementById('completedTransactions').innerText = data.filter(t=>t.status==='completed').length;
  document.getElementById('totalRevenue').innerText = formatRupiah(
    data.filter(t=>t.status==='completed').reduce((a,b)=>a+b.total,0)
  );

  if(!data.length){
    container.innerHTML = '<div class="empty">Tidak ada transaksi ditemukan</div>';
    return;
  }

  let html = '<table><thead><tr>\
    <th>ID</th><th>Tanggal</th><th>Pelanggan</th><th>Produk</th>\
    <th>Jumlah</th><th>Total</th><th>Metode</th><th>Status</th>\
    </tr></thead><tbody>';

  data.forEach(trx=>{
    html += `<tr>
      <td>${trx.id}</td>
      <td>${trx.date}</td>
      <td>${trx.customerName}</td>
      <td>${trx.products}</td>
      <td>${trx.quantity}</td>
      <td>${formatRupiah(trx.total)}</td>
      <td>${trx.paymentMethod}</td>
      <td><span class="status ${trx.status}">${trx.status}</span></td>
    </tr>`;
  });

  html += '</tbody></table>';
  container.innerHTML = html;
}

function exportCSV(){
  const data = getFiltered();
  let csv = "ID,Tanggal,Pelanggan,Produk,Jumlah,Total,Metode,Status\n";
  data.forEach(t=>{
    csv += `${t.id},${t.date},${t.customerName},${t.products},${t.quantity},${t.total},${t.paymentMethod},${t.status}\n`;
  });

  const blob = new Blob([csv], {type:'text/csv'});
  const url = URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.href = url;
  a.download = 'laporan.csv';
  a.click();
}

function printReport(){
  window.print();
}

document.querySelectorAll('input, select').forEach(el=>{
  el.addEventListener('input', render);
});

render();
</script>

</body>
</html>